;******* Psuedo-Parallax macro instruction set *******
;Kurt Kuhlmann Microchip FAE  1/5/97

; L is a literal
; fr, fr1, fr2 represent file registers
; Port,bit represents a file register bit location (0-7)
; addr is a program address

addl   MACRO fr,L		;add L into fr
	movlw L
	addwf fr,F
	ENDM

add    MACRO fr1,fr2	;add fr2 into fr1
	movf fr2,W
	addwf fr1,F                  
	ENDM

addb   MACRO fr,Port,bit	;add bit to fr
	btfsc Port,bit
	incf fr,F
	ENDM

andl   MACRO fr,L		;bitwise and L mask to fr
	movlw L
	andwf fr,F
	ENDM

and    MACRO fr1,fr2	;bitwise and fr1 with fr2 mask
	movf fr2,W
	andwf fr1,F
	ENDM

cjal   MACRO fr,L,addr	;compare and jump if fr > L
	movlw L^0FFh
	addwf fr,W
	btfsc 3,0		;Carry bit
	goto addr
	ENDM

cja    MACRO fr1,fr2,addr	;compare and jump if fr1 > fr2	
	movf fr1,W
	subwf fr2,W
	btfss 3,0
	goto addr
	ENDM

cjael  MACRO fr,L,addr	;compare and jump if fr >= L
	movlw L
	subwf fr,W
	btfsc 3,0
	goto addr
	ENDM

cjae   MACRO fr1,fr2,addr	;compare and jump if fr1 >= fr2
	movf fr2,W
	subwf fr1,W
	btfsc 3,0
	goto addr
	ENDM

cjbl   MACRO fr,L,addr	;compare and jump if fr < L
	movlw L
	subwf fr,W
	btfss 3,0
	goto addr
	ENDM

cjb    MACRO fr1,fr2,addr	;compare and jump if fr1 < fr2
	movf fr2,W
	subwf fr1,W
	btfss 3,0
	goto addr
	ENDM

cjbel  MACRO fr,L,addr	;compare and jump if fr <= L
	movlw L^0FFh
	addwf fr,W
	btfss 3,0
	goto addr
	ENDM

cjbe   MACRO fr1,fr2,addr	;compare and jump if fr1 <= fr2
	movf fr1,W
	subwf fr2,W
	btfsc 3,0
	goto addr
	ENDM

cjel   MACRO fr,L,addr	;compare and jump if fr = L
	movlw L
	subwf fr,W
	btfsc 3,2
	goto addr
	ENDM

cje    MACRO fr1,fr2,addr	;compare and jump if fr1 = fr2
	movf fr2,W
	subwf fr1,W
	btfsc 3,2
	goto addr
	ENDM

cjnel  MACRO fr,L,addr	;compare and jump if fr != L
	movlw L
	subwf fr,W
	btfss 3,2
	goto addr
	ENDM

cjne   MACRO fr1,fr2,addr	;compare and jump if fr1 != fr2
	movf fr2,W
	subwf fr1,W
	btfss 3,2
	goto addr
	ENDM

clc     MACRO 		;clear carry bit
	bcf   3,0
	ENDM

			;Below only work on single instructions
csal   MACRO fr,L		;compare and skip if fr > L
	movlw L^0ffh
	addwf fr,W
	btfss 3,0
	ENDM

csa    MACRO fr1,fr2	;compare and skip if fr1 > fr2
	movf fr1,W
	subwf fr2,W
	btfsc 3,0
	ENDM

csael  MACRO fr,L		;compare and skip if fr >= L
	movlw L
	subwf fr,W
	btfss 3,0
	ENDM

csae   MACRO fr1,fr2	;compare and skip if fr1 >= fr2
	movf fr2,W
	subwf fr1,W
	btfss 3,0
	ENDM

csbl   MACRO fr,L		;compare and skip if fr < L 
	movlw L
	subwf fr,W
	btfsc 3,0
	ENDM

csb    MACRO fr1,fr2	;compare and skip if fr1 < fr2
	movf fr2,W
	subwf fr1,W
	btfsc 3,0
	ENDM

csbel  MACRO fr,L		;compare and skip if fr <= L 
        movlw L^0FFh
	addwf fr,W
	btfsc 3,0
	ENDM

csbe   MACRO fr1,fr2	;compare and skip if fr1 <= fr2 
	movf fr1,W
	subwf fr2,W
	btfss 3,0
	ENDM

csel   MACRO fr,L		;compare and skip if fr = L 
	movlw L
	subwf fr,W
	btfss 3,2
	ENDM

cse    MACRO fr1,fr2	;compare and skip if fr1 = fr2 
	movf fr2,W
	subwf fr1,W
	btfss 3,2
	ENDM

csnel  MACRO fr,L		;compare and skip if fr != L 
	movlw L
	subwf fr,W
	btfsc 3,2
	ENDM

csne   MACRO fr1,fr2	;compare and skip if fr1 != fr2 
	movf fr2,W
	subwf fr1,W
	btfsc 3,2
	ENDM


djnz   MACRO fr,addr	;decrement fr and jump when not zero
	decfsz fr,F
	goto addr
	ENDM	

ijnz   MACRO fr,addr	;decrement fr and jump when not zero
	incfsz fr,F
	goto addr
	ENDM	
jb  MACRO  Port,bit,addr	;jump if bit is set
	btfsc Port,bit
	goto addr
	ENDM

jc  MACRO  addr			;jump if carry bit is set 
	btfsc 3,0
	goto addr
	ENDM

jnb  MACRO  Port,bit,addr	;jump if bit is not set 
	btfss Port,bit
	goto addr
	ENDM

jnc  MACRO  addr			;jump if carry bit is not set 
	btfss 3,0
	goto addr
	ENDM

jz  MACRO  addr			;jump if zero bit is set 
	btfsc 3,2
	goto addr
	ENDM

jnz  MACRO  addr			;jump if zero bit is not set 
	btfss 3,2
	goto addr
	ENDM

movl    MACRO fr,L		;move L into fr
	movlw L
	movwf fr
	ENDM

mov    MACRO fr1,fr2 		;move fr2 into fr1
	movf fr2,W
	movwf fr1
	ENDM

movb    MACRO Port1,bit1,Port2,bit2	;move Port2,bit2 into Port1,bit1
	btfss Port2,bit2
	bcf Port1,bit1
	btfsc Port2,bit2
	bsf Port1,bit1
	ENDM

movnb   MACRO Port1,bit1,Port2,bit2	;move NOT Port2,bit2 into Port1,bit1
	btfsc Port2,bit2
	bcf Port1,bit1
	btfss Port2,bit2
	bsf Port1,bit1
	ENDM

neg    MACRO fr		;twos complement negation of fr
	comf fr,F
	incf fr,F
	ENDM

not    MACRO fr 		;ones complement NOT fr
	comf fr,F
	ENDM

or    MACRO fr1,fr2 	;bitwise OR fr2 mask into fr1
	movf fr2,W
	iorwf fr1,F
	ENDM

orl   MACRO fr,L		;bitwise OR L mask into fr1
	movlw L
	iorwf fr,F
	ENDM

sb   MACRO Port,bit	;skip if bit is set
	btfss Port,bit
	ENDM

sc   MACRO 			;skip if carry bit is set
	btfss 3,0
	ENDM

snb   MACRO Port,bit	;skip if bit is cleared 
	btfsc Port,bit
	ENDM

snc   MACRO 		;skip if carry bit is cleared 
	btfsc 3,0
	ENDM

sz   MACRO 			;skip if zero bit is set 
	btfss 3,2
	ENDM

snz   MACRO 		;skip if zero bit is cleared 
	btfsc 3,2
	ENDM

subl   MACRO fr,L		;subtract L from fr
	movlw L
	subwf fr,F
	ENDM

sub   MACRO fr1,fr2	;subtract fr2 from fr1 
	movf fr2,W
	subwf fr1,F
	ENDM

subb   MACRO fr,Port,bit	;subtract bit from fr 
	btfss Port,bit
	decf fr,F
	ENDM

swapwf MACRO fr		;swap W and fr values
	xorwf fr,F
	xorwf fr,W
	xorwf fr,F
	ENDM

test    MACRO fr		;set or clear zero bit 
	movf fr,F
	ENDM

tb	MACRO fr,bit	;toggle bit in fr 
	movlw 1<<bit
	xorwf fr
	ENDM

xorl   MACRO fr,L		;exclusive or fr with L mask
	movlw L
	xorwf fr,F
	ENDM

xor   MACRO  fr1,fr2	;exclusive or fr1 with fr2 mask 
	mov fr2,W
	xorwf fr1,F
	ENDM



